/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IAttribute;
import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.IAttributeListener;
import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import dev.toma.gunsrpg.common.attribute.Attribs;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

public class PlayerAttributes
implements IAttributeProvider,
IPlayerCapEntry {
    private final Map<IAttributeId, IAttribute> attributeMap = new HashMap<IAttributeId, IAttribute>();
    private final AttributeListener listener = new AttributeListener();
    private IPlayerCapEntry.IClientSynchReq syncRequest;

    @Override
    public IAttribute getAttribute(IAttributeId id) {
        IAttribute attribute = this.attributeMap.get(id);
        if (attribute == null) {
            this.addAttribute(id);
            return this.attributeMap.get(id);
        }
        return attribute;
    }

    @Override
    public void addAttribute(IAttributeId id) {
        IAttribute attribute = id.createNewInstance();
        this.attributeMap.put(id, attribute);
        attribute.addAttributeListener(this.listener);
        this.safeSync();
    }

    @Override
    public void tick() {
        this.attributeMap.values().forEach(IAttribute::tickAttributes);
    }

    @Override
    public double getAttributeValue(IAttributeId id) {
        IAttribute attribute = this.getAttribute(id);
        return attribute != null ? attribute.value() : id.getBaseValue();
    }

    @Override
    public void toNbt(CompoundNBT nbt) {
        ListNBT listNBT = new ListNBT();
        for (Map.Entry<IAttributeId, IAttribute> entry : this.attributeMap.entrySet()) {
            IAttributeId attributeId = entry.getKey();
            IAttribute attribute = entry.getValue();
            CompoundNBT entryNbt = new CompoundNBT();
            entryNbt.func_74778_a("id", attributeId.getId().toString());
            entryNbt.func_218657_a("data", attribute.serializeNBT());
            listNBT.add((Object)entryNbt);
        }
        nbt.func_218657_a("attributes", (INBT)listNBT);
    }

    @Override
    public void fromNbt(CompoundNBT nbt) {
        this.attributeMap.clear();
        ListNBT list = nbt.func_150297_b("attributes", 9) ? nbt.func_150295_c("attributes", 10) : new ListNBT();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT attributeNbt = list.func_150305_b(i);
            ResourceLocation idPath = new ResourceLocation(attributeNbt.func_74779_i("id"));
            CompoundNBT data = attributeNbt.func_74775_l("data");
            IAttributeId attributeId = Attribs.find(idPath);
            if (attributeId == null) {
                GunsRPG.log.warn("Unknown attribute with Id: {}, skipping...", (Object)idPath);
                continue;
            }
            IAttribute attribute = attributeId.createNewInstance();
            attribute.deserializeNBT((INBT)data);
            attribute.addAttributeListener(this.listener);
            this.attributeMap.put(attributeId, attribute);
        }
    }

    @Override
    public void setClientSynch(IPlayerCapEntry.IClientSynchReq request) {
        this.syncRequest = request;
    }

    @Override
    public int getFlag() {
        return 16;
    }

    private void safeSync() {
        if (this.syncRequest != null) {
            this.syncRequest.makeSyncRequest();
        }
    }

    public class AttributeListener
    implements IAttributeListener {
        private final UUID uuid = UUID.randomUUID();

        @Override
        public void onModifierAdded(IAttributeModifier modifier) {
            this.sendSyncRequest();
        }

        @Override
        public void onModifierRemoved(IAttributeModifier modifier) {
            this.sendSyncRequest();
        }

        @Override
        public void onValueChanged(double value) {
            this.sendSyncRequest();
        }

        private void sendSyncRequest() {
            PlayerAttributes.this.safeSync();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeListener that = (AttributeListener)o;
            return this.uuid.equals(that.uuid);
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }
    }
}

